
import urllib.request
import sys
import websocket
import os
import time
import json
import socket

def GetIDs(printerIP):
    broadcast_address = (printerIP, 3000)
    broadcast_message = "M99999"
    mainboardID=None
    printerID=None
    udp_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    udp_socket.setsockopt(socket.SOL_SOCKET, socket.SO_BROADCAST, 1)
    result=False
    try:
        #print(f"Sending broadcast message: {broadcast_message}")
        udp_socket.sendto(broadcast_message.encode(), broadcast_address)

        udp_socket.settimeout(1)
        while True:
            try:
                data, addr = udp_socket.recvfrom(1024)
                dd=eval(data)
                printerID=dd['Id']
                mainboardID=dd['Data']['MainboardID']
                result=True
            except socket.timeout:
                if result == False:
                    print("Socket timeout")
                break
    finally:
            udp_socket.close()
            return printerID,mainboardID

def CCPrint(fname,PrinterIP):
    ws = websocket.WebSocket()
    ws.connect("ws://"+PrinterIP+":3030/websocket")
    ts = int(time.time())
    cmdstring={
      "Id": printerID,
      "Data": {
       "Cmd": 128,
       "Data": {
        "Filename": fname,
        "StartLayer": 0,
        "Calibration_switch": 0,
        "PrintPlatformType": 0,
        "Tlp_Switch": 0
        },
      "RequestID": "bc6990ec21c94b9694f7e0be31b99514",
      "MainboardID": mainboardID,
      "TimeStamp": ts,
      "From": 1
      }
    }
    #print(cmdstring)
    ws.send(json.dumps(cmdstring))
    ack=json.loads(ws.recv())
    ws.close()
    return ack

def CCGetStatus(PrinterIP):
    ws = websocket.WebSocket()
    ws.connect("ws://"+PrinterIP+":3030/websocket")
    ts = int(time.time())
    cmdstring={
      "Id": "",
      "Data": {
        "Cmd": 0,
        "Data": {},
        "RequestID": "aaaaaa",
        "MainboardID":mainboardID,
        "TimeStamp": ts,
        "From": 1
      }
    }
    ws.send(json.dumps(cmdstring))
    ack=json.loads(ws.recv())  #ack of the command
    ack2=json.loads(ws.recv()) # return the response of the command
    ws.close()
    return(ack2)


def CCIsIdling(PrinterIP):
    ack = CCGetStatus(PrinterIP)
    #print(ack)
    #print(ack['Status']['PrintInfo']['Status'])
    try:
      if ack['Status']['PrintInfo']['Status']== 0 or  ack['Status']['PrintInfo']["Status"]== 9 :
        return True
    except:
      return False

if len(sys.argv) == 1:
    print("Must have an IP address")
    sys.exit()
    
PrinterIP = sys.argv[1]

printerID,mainboardID = GetIDs(PrinterIP)
if printerID is None:
    print("No response from printer")
    sys.exit()

ack=CCPrint('/usb/M8803Command.gcode',PrinterIP)
time.sleep(1)
#zzz check ack for validity
IsIdling=False
while not IsIdling:
  #zzz probably needs timeout
  IsIdling = CCIsIdling(PrinterIP)


page = urllib.request.urlopen('http://'+PrinterIP+'/usb/user_printer.cfg')
data=page.read().decode('utf-8').splitlines()

for line in data:
  if line.__contains__('points'):
   line = line.replace("points : ","").split(",")
   line = [float(f) for f in line]
#   print('-----Raw Data--------------')
#   print(line)
   print('-----Bed mesh delta from the average, as viewed from the top-------------')
   ave=0.0
   for f in line: ave=ave+f
   ave=ave/121.0
   print('Average is: '+str(round(ave,4)))
   for i in range(11):
     delta=[]
     for j in range(11):
       number = line[j+(10-i)*11] - ave
       if number >= 0 :
           delta.append(" "+f"{ round(number,2):.2f}")
       else:
           delta.append(f"{ round(number,2):.2f}")
     print(delta)
   print('-----Bed mesh raw data rounded, as viewed from the top--------------')
   for i in range(11):
     linedata=[]
     for j in range(11):
       linedata.append(f"{round(line[j+(10-i)*11],3):.3f}")
     print(linedata)

   break

"""
MIT No Attribution

Copyright 2025 Charles Lingel

Permission is hereby granted, free of charge, to any person obtaining a copy of this software
and associated documentation files (the "Software"), to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
"""
